/*  motsort.c - Sort Motorola phonebook files in medit textual format
 *    		<idx> <num> <name> <cr>
 *
 *  Version 0.1: Wrote under Linux in ANSI C: should compile in any
 *		 decent compiler (even in DOS).
 *
 *  Copyright (C) 1999  Stephan Zegherd <inverter@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#define N_ENTRIES 512
#define MAX_S 1024

#define MOT_NAME 16
#define MOT_NUM 32		/* Not right, but ok.. don't want to check + case.. lazyness.. */
#define MOT_MEM 100

struct s_pb {

    char name[MOT_NAME + 1];
    char num[MOT_NUM + 1];

} pb_entry[N_ENTRIES];

struct s_pb tmp;

FILE *inf, *outf;

void about(char *prgname)
{
    printf("motsort v.0.1 - (c) 1999 Stephan Zegherd <inverter@gmx.de>\n" \
     "                Licensed under GNU GPL\n" \
     "                Sort textual phonebook dump made with medit(x)\n" \
	   "Usage: %s <in-file> <out-file>\n", prgname);
    exit(1);
}


int main(int argc, char *argv[])
{
    char *inname, *outname;
    int i, j, count, rublen = 0;
    char ins[MAX_S];

    if (argc != 3)
	about(argv[0]);

    inname = argv[1];
    outname = argv[2];

    inf = fopen(inname, "r");
    if (inf == NULL) {
	perror("Unable to open input file");
	return -2;
    }
    outf = fopen(outname, "w");
    if (outf == NULL) {
	perror("Unable to open input file");
	return -2;
    }
    printf("Reading..");
    fflush(stdout);


    while (!feof(inf)) {

	fgets(ins, MAX_S, inf);
	/* Remove unwanted \r \n ' '.. safer version ;-D */
	for (i = strlen(ins) - 1; i > 0; i--)
	    if ((ins[i] == '\n') || (ins[i] == '\r') || (ins[i] == 0x20))
		ins[i] = 0;
	    else
		break;

	if (!feof(inf)) {
	    for (i = 0; i < strlen(ins); i++) {		/* Parsing */
		if (ins[i] == 0x20) {
		    for (; i < strlen(ins) && ins[i] == 0x20; i++);	/* skip spaces */
		    if (i < strlen(ins)) {
			j = i;
			for (; i < strlen(ins) && ins[i] != 0x20; i++);
			ins[i] = 0;

			/* Copy entry */
			pb_entry[rublen].num[MOT_NUM] = 0;	/* Null.. */
			memcpy(&pb_entry[rublen].num, ins + j, strlen(ins + j) < MOT_NUM ? strlen(ins + j) : MOT_NUM);
			ins[i] = 0x20;
			for (; i < strlen(ins) && ins[i] == 0x20; i++);		/* skip spaces */

			if (i < strlen(ins)) {
			    j = i;

			    /* Copy entry */
			    pb_entry[rublen].name[MOT_NAME] = 0;	/* Null.. */
			    memcpy(pb_entry[rublen].name, ins + j, strlen(ins + j) < MOT_NAME ? strlen(ins + j) : MOT_NAME);
#ifdef DEBUG
			    printf("%s: %s\n", pb_entry[rublen].name, pb_entry[rublen].num);
#endif
			    rublen++;
			}
		    }
		}
	    }
	}
    }

    printf("found %d names.\n", rublen);

    /* Iper-lazy sorting.. */
    printf("Sorting..");
    fflush(stdout);

    for (i = 0; i < rublen; i++) {
	for (j = i + 1; j < rublen; j++) {
	    /* Sould by strcmpi.. but *again* LAZYNESS! */
	    if (strcmp(pb_entry[j].name, pb_entry[i].name) < 0) {
		strcpy(tmp.name, pb_entry[j].name);
		strcpy(pb_entry[j].name, pb_entry[i].name);
		strcpy(pb_entry[i].name, tmp.name);

		strcpy(tmp.num, pb_entry[j].num);
		strcpy(pb_entry[j].num, pb_entry[i].num);
		strcpy(pb_entry[i].num, tmp.num);
	    }
	}
    }
    printf("done.\n");

    printf("Writing..");
    for (i = 0; i < MOT_MEM; i++) {
	if (i < rublen)
	    fprintf(outf, "%d %s %s\n", i + 1, pb_entry[i].num, pb_entry[i].name);
	else
	    fprintf(outf, "%d\n", i + 1);
    }

    printf("done.\n");

    fclose(inf);
    fclose(outf);

    return 0;
}
