Program ASIMDELUXE;   { 24-06-98 V4.0 }

Uses crt,dos,ini_api, Strings, FileList, Misc;

type cad2=string[2];
     cad4=string[4];
     gtab=array [0..511] of byte;


CONST
   X_LIMIT_HEX = 59;
   X_START_HEX = 12;
   WIN_DELAY = 500;
   NAM: array [1..41] of word=($2FE2,$6F05,$6F07,$6F10,$6F11,$6F13,$6F14,$6F15,
                               $6F16,$6F20,$6F25,$6F30,$6F31,$6F37,$6F38,$6F39,
                               $6F3A,$6F3B,$6F3C,$6F3D,$6F3E,$6F3F,$6F40,$6F41,
                               $6F42,$6F43,$6F44,$6F45,$6F4A,$6F4B,$6F74,$6F78,
                               $6F7B,$6F7E,$6FAD,$6FAE,$7F10,$7F20,$7F21,$7F40,
                               $3F00);
   INEXT    = '.DAT';
   About    = 'ASIM EMULATOR DELUXE V4.0 Beta6'; (* Version *)
   Authors  = '  Deluxe version by: Stephan Zegherd'+#$0a+#$0d+
              'Original program by: The Android'+#$0a+#$0d+
              '            COMP128: Marc Briceno, Ian Goldberg, and David Wagner'+#$0a+#$0d+
              'Misc pascal library: T.Hill, A. Christophe';

   URL      = '          Home Page: http://www.image.dk/~jckrarup/motpages.html';
   CFG_EXT  = 'INI';
   NOPARIT  = 0;
   PAREVEN  = $18;
   PARODD   = $08;
   BITS8    = $03;
   TDL      = $01;
   LPE      = $02;
   OUT2     = $08;
   COP1     = $21;
   COP2     = $20;
   COM1     = $3F8;
   COM2     = $2F8;
   COM3     = $3E8;
   COM4     = $2E8;
   IRQ3     = $08;
   VECTOR3  = 11;
   IRQ4     = $10;
   VECTOR4  = 12;

   MAXFRAME = 10240;

{ Original Colors }

{   C_2ndBG  = White;
   C_MainBG	= LightGray;
   C_cntsBG = Black;
   C_frillBG= Magenta;
   C_winBG  = Blue;

   C_Alert  = Red;
   C_Normal = White;
   C_Info	= Blue; }

{ Changed Colors }

   C_2ndBG  = Blue;
   C_MainBG = Blue;
   C_DumpBG = Blue;
   C_cntsBG = Blue;
   C_frillBG= Magenta;
   C_winBG  = Blue;

   C_DumpS1 = 14;
   C_DumpS2 = LightGreen;
   C_DumpS3 = 15;
   C_smlWin = LightBlue;
   C_Alert  = LightCyan;
   C_Normal = White;
   C_Info   = Yellow;
   C_About  = Yellow;
   C_InfoS  = Yellow;
   C_Eviden = White;
   C_Slick  = LightGray;
   C_Sim    = White;

   A_Cursor = 71;
table_0: array [0..511] of byte= (
        102,177,186,162,  2,156,112, 75, 55, 25,  8, 12,251,193,246,188,
        109,213,151, 53, 42, 79,191,115,233,242,164,223,209,148,108,161,
        252, 37,244, 47, 64,211,  6,237,185,160,139,113, 76,138, 59, 70,
         67, 26, 13,157, 63,179,221, 30,214, 36,166, 69,152,124,207,116,
        247,194, 41, 84, 71,  1, 49, 14, 95, 35,169, 21, 96, 78,215,225,
        182,243, 28, 92,201,118,  4, 74,248,128, 17, 11,146,132,245, 48,
        149, 90,120, 39, 87,230,106,232,175, 19,126,190,202,141,137,176,
        250, 27,101, 40,219,227, 58, 20, 51,178, 98,216,140, 22, 32,121,
         61,103,203, 72, 29,110, 85,212,180,204,150,183, 15, 66,172,196,
         56,197,158,  0,100, 45,153,  7,144,222,163,167, 60,135,210,231,
        174,165, 38,249,224, 34,220,229,217,208,241, 68,206,189,125,255,
        239, 54,168, 89,123,122, 73,145,117,234,143, 99,129,200,192, 82,
        104,170,136,235, 93, 81,205,173,236, 94,105, 52, 46,228,198,  5,
         57,254, 97,155,142,133,199,171,187, 50, 65,181,127,107,147,226,
        184,218,131, 33, 77, 86, 31, 44, 88, 62,238, 18, 24, 43,154, 23,
         80,159,134,111,  9,114,  3, 91, 16,130, 83, 10,195,240,253,119,
        177,102,162,186,156,  2, 75,112, 25, 55, 12,  8,193,251,188,246,
        213,109, 53,151, 79, 42,115,191,242,233,223,164,148,209,161,108,
         37,252, 47,244,211, 64,237,  6,160,185,113,139,138, 76, 70, 59,
         26, 67,157, 13,179, 63, 30,221, 36,214, 69,166,124,152,116,207,
        194,247, 84, 41,  1, 71, 14, 49, 35, 95, 21,169, 78, 96,225,215,
        243,182, 92, 28,118,201, 74,  4,128,248, 11, 17,132,146, 48,245,
         90,149, 39,120,230, 87,232,106, 19,175,190,126,141,202,176,137,
         27,250, 40,101,227,219, 20, 58,178, 51,216, 98, 22,140,121, 32,
        103, 61, 72,203,110, 29,212, 85,204,180,183,150, 66, 15,196,172,
        197, 56,  0,158, 45,100,  7,153,222,144,167,163,135, 60,231,210,
        165,174,249, 38, 34,224,229,220,208,217, 68,241,189,206,255,125,
         54,239, 89,168,122,123,145, 73,234,117, 99,143,200,129, 82,192,
        170,104,235,136, 81, 93,173,205, 94,236, 52,105,228, 46,  5,198,
        254, 57,155, 97,133,142,171,199, 50,187,181, 65,107,127,226,147,
        218,184, 33,131, 86, 77, 44, 31, 62, 88, 18,238, 43, 24, 23,154,
        159, 80,111,134,114,  9, 91,  3,130, 16, 10, 83,240,195,119,253);

table_1: array [0..255] of byte= (
         19, 11, 80,114, 43,  1, 69, 94, 39, 18,127,117, 97,  3, 85, 43,
         27,124, 70, 83, 47, 71, 63, 10, 47, 89, 79,  4, 14, 59, 11,  5,
         35,107,103, 68, 21, 86, 36, 91, 85,126, 32, 50,109, 94,120,  6,
         53, 79, 28, 45, 99, 95, 41, 34, 88, 68, 93, 55,110,125,105, 20,
         90, 80, 76, 96, 23, 60, 89, 64,121, 56, 14, 74,101,  8, 19, 78,
         76, 66,104, 46,111, 50, 32,  3, 39,  0, 58, 25, 92, 22, 18, 51,
         57, 65,119,116, 22,109,  7, 86, 59, 93, 62,110, 78, 99, 77, 67,
         12,113, 87, 98,102,  5, 88, 33, 38, 56, 23,  8, 75, 45, 13, 75,
         95, 63, 28, 49,123,120, 20,112, 44, 30, 15, 98,106,  2,103, 29,
         82,107, 42,124, 24, 30, 41, 16,108,100,117, 40, 73, 40,  7,114,
         82,115, 36,112, 12,102,100, 84, 92, 48, 72, 97,  9, 54, 55, 74,
        113,123, 17, 26, 53, 58,  4,  9, 69,122, 21,118, 42, 60, 27, 73,
        118,125, 34, 15, 65,115, 84, 64, 62, 81, 70,  1, 24,111,121, 83,
        104, 81, 49,127, 48,105, 31, 10,  6, 91, 87, 37, 16, 54,116,126,
         31, 38, 13,  0, 72,106, 77, 61, 26, 67, 46, 29, 96, 37, 61, 52,
        101, 17, 44,108, 71, 52, 66, 57, 33, 51, 25, 90,  2,119,122, 35);

table_2: array [0..127] of byte= (
         52, 50, 44,  6, 21, 49, 41, 59, 39, 51, 25, 32, 51, 47, 52, 43,
         37,  4, 40, 34, 61, 12, 28,  4, 58, 23,  8, 15, 12, 22,  9, 18,
         55, 10, 33, 35, 50,  1, 43,  3, 57, 13, 62, 14,  7, 42, 44, 59,
         62, 57, 27,  6,  8, 31, 26, 54, 41, 22, 45, 20, 39,  3, 16, 56,
         48,  2, 21, 28, 36, 42, 60, 33, 34, 18,  0, 11, 24, 10, 17, 61,
         29, 14, 45, 26, 55, 46, 11, 17, 54, 46,  9, 24, 30, 60, 32,  0,
         20, 38,  2, 30, 58, 35,  1, 16, 56, 40, 23, 48, 13, 19, 19, 27,
         31, 53, 47, 38, 63, 15, 49,  5, 37, 53, 25, 36, 63, 29,  5,  7);

table_3: array [0..63] of byte= (
          1,  5, 29,  6, 25,  1, 18, 23, 17, 19,  0,  9, 24, 25,  6, 31,
         28, 20, 24, 30,  4, 27,  3, 13, 15, 16, 14, 18,  4,  3,  8,  9,
         20,  0, 12, 26, 21,  8, 28,  2, 29,  2, 15,  7, 11, 22, 14, 10,
         17, 21, 12, 30, 26, 27, 16, 31, 11,  7, 13, 23, 10,  5, 22, 19);

table_4: array [0..31] of byte= (
         15, 12, 10,  4,  1, 14, 11,  7,  5,  0, 14,  7,  1,  2, 13,  8,
         10,  3,  4,  9,  6,  0,  3,  2,  5,  6,  8,  9, 11, 13, 15, 12);

table: array [0..4] of ^gtab= (@table_0,@table_1,@table_2,@table_3,@table_4);

Var
    TickCount : LongInt Absolute $0 : $46C;
    ColorBuf  : Byte Absolute $B800 : $0;
    FrameBuf2 : Byte Absolute $B800 : $0FA0;
    FrameBuf3 : Byte Absolute $B800 : $1F40;
    FrameBuf4 : Byte Absolute $B800 : $2EE0;

    simoutput: array [0..11] of byte;
    rand:  array [0..15] of byte;
    skey:  array [0..15] of byte;
    ATR:array  [1..40] of byte;        { ATR MAXIM 40 BYTES }
    ADN:array  [1..2800] of byte;      { 6F3A ABREV. DIALING NUMBER 100 * $1C }
    CLO:array  [0..MAXFRAME] of byte;      { USADO POR EMULACION CLONE CARD }
    CLOMIRROR:array  [0..MAXFRAME] of byte;{ Undo mirror for CLO when editing }
    SMS:array  [1..2640] of byte;      { 6F3C SHORT MESSAGES 15 * $B0 }
    FIL:array  [1..41,1..255] of byte; { MAX 41 FILES OF 255 BYTES }
    MEN:array  [1..42,1..36]  of byte; { FILE MENSAGES MEN 42 IS AUTHENTICATION}
    ATRLEN   : BYTE;                   { LENGHT FOR ATR  }
    CONVEN   : BOOLEAN;                { ISO CONVENTION, TRUE= NORMAL}
    RES      : BOOLEAN;                { RESET }
    PIN      : WORD;                   { PIN 1 }
    FILENUM  : BYTE;                   { CURRENT FILE NUM  }
    FILENAME : WORD;                   { CURRENT FILE NAME }
    FOUND    : BOOLEAN;                { FOUND SELECTED FILE }
    COUNT    : BYTE;                   { CURRENT FILE BYTE }
    CLA,INS,P1,P2,P3 : BYTE;           { ISO 7816 INSTRUCTIONS  }
    BYTEDLY  : WORD;                   { INTERBYTE DELAY        }
    INP:text;                          { FILE *.DAT }
    T: file of byte ;                  { FOR OPEN FILES AS BIN }
    infile:string;                     { NAME OF SIM.DAT FILE}
    line:string[255];                  { INPUT LINE FOR READ SIM.DAT }
    frase:string[25];                  { KEYBOARD BUFFER }
    DefFrameName,
    DefSIMName                         : String;
    numline:word;                      { NUM OF LINES    }
    INICIO:WORD;
    LOADERR:boolean;                   { ERROR LOAD SCRIPT FILE }
    BigBuffer : Boolean;
    pepe:string;

    RRB,RDM,RCL,RCI,RCM,REL,MSR: word;
    ASIMINI                    : string[255];
    serie,irq,velocidad        : word;
    adapter                    : byte;
    comnum                     : char;
    dumy                       : byte;
    vector                     : byte;
    lastread,last              : integer;
    Divisor,i,j                : word;
    oldirq                     : pointer;
    BUFSER                     : array [0..2047] of byte;

    salir,ret,abort,error:boolean;
    xpos,ypos:byte;
    key: char;
    screen:array [0..4000] of byte absolute $B800:0000;
    buffer:array [160..4000] of byte;

function hex(b:byte):cad2;
const  digithex: array[0..15] of char ='0123456789ABCDEF';
var BLOW,BHIGH:BYTE;
begin
       BHIGH:=B SHR 4;  BLOW:=B AND $0F;
       hex:=digithex[bhigh]+digithex[blow];
end;

function ihex(b:byte):cad2;
const  digithex: array[0..15] of char ='0123456789ABCDEF';
var BLOW,BHIGH:BYTE;
begin
       BHIGH:=B SHR 4;  BLOW:=B AND $0F;
       ihex:=digithex[blow]+digithex[bhigh];
end;

function hexadr(w:word):cad4;
begin
    hexadr:=hex(trunc(w/256))+hex(w and 255);
end;

procedure clearpan;
var i:integer;
begin
     TextBackGround (C_2ndBG);
     for i:=80 to 2000 do screen[2*i]:=0;
     gotoxy (1,2);
end;

function mirror (ch:byte):byte;
var k,temp:byte;
begin
      temp:=0;
      ch:=ch xor $ff;
      for k:=0 to 7 do begin
                            temp:=temp shl 1;
                            temp:=temp+((ch shr k) and 1);
                       end;
      mirror:=temp;
end;

procedure entrada(Indicador,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : Word);
interrupt;
begin
     inline($FB);
     if last >= 1023 then last := 0 else last:=last+1;
     BUFSER[last] := port[RRB];
     port[COP2] := $20;
end;

{$F+}
procedure out;
begin
     Port[RCI]  := 0;
     Port[COP1] := Port[COP1] OR IRQ;
     Port[RCM]  := 0;
     SetIntVec(vector,oldirq);
end;
{$F-}

procedure init;
begin
     irq:=IRQ4;
     vector:=VECTOR4;
     if (serie=com2) or (serie=com4) then
        begin
             irq:=IRQ3;
             vector:=VECTOR3;
        end;
     RRB:= serie;
     RDM:= serie+1;
     RCL:= serie+3;
     RCI:= serie+1;
     RCM:= serie+4;  {modem control register}
     REL:= serie+5;
     MSR:= serie+6;  {modem status register}
     divisor:=115200 div velocidad;
     lastread:= 0;
     last :=0;
     Port[RCI] := 0;
     GetIntVec(vector,oldirq);
     ExitProc := @out;
     SetIntVec(vector,@Entrada);
     Port[RCL]  := Port[RCL] or $80;
     Port[RRB]  := lo(Divisor);
     Port[RDM]  := hi(Divisor);
     if conven then Port[RCL]  := BITS8 OR PAREVEN  { DIRECT CONVENTION }
     else Port[RCL]  := BITS8 OR PARODD;            { INVERS CONVENTION }
     Port[RCM]  := TDL OR LPE OR OUT2;
     Port[COP1] := Port[COP1] AND (NOT IRQ);
     dumy       := Port[RRB];
     dumy       := Port[REL];
     Port[RCI]  := $01;
end;

procedure wait (micros:word); ASSEMBLER;
asm
   mov ah,86h
   mov al,15h
   mov cx,0
   mov dx,micros
   int 15h
end;

function status:boolean;
begin
  if last <> lastread then status:=true
  else status:=false;
end;

Function GotReset : Boolean;

Begin
     If Adapter=0 { Legacy } Then
        Begin
             GotReset:=(port [MSR] and $20)=$20;
        End Else { Season }
        Begin
             GotReset:=(port [MSR] and $80)=$80;
        End;
End;

function getbyte:byte;
var timeout:longint;
var tmp: Boolean;
begin
    res:=false;
    repeat
          tmp:=GotReset;
    until status or keypressed or (tmp);
    if (tmp<>True) and not keypressed then
          begin
               if lastread >= 1023 then lastread := 0
               else lastread := lastread+1;
               if conven then getbyte:= BUFSER[lastread]
               else getbyte:=mirror (BUFSER[lastread]);
          end
    else  begin
              res:=true;
              getbyte:=0;
          end;
end;

procedure sendbyte(Ch:byte);
begin
     if not conven then ch:=mirror (ch);
     port[RRB]:=ch;
     dumy:=getbyte;
     wait (bytedly);
end;

function sendatr:boolean;
var i:byte;
begin
     i:=1;
     res:=FALSE;
     while not res and (i<=atrlen) and not keypressed do
           begin
                sendbyte (atr[i]);
                write (hex(atr[i]));
                i:=i+1;
           end;
     writeln;
     if not res and not keypressed then sendatr:=TRUE
     else sendatr:=FALSE;
end;

procedure doscroll;
var i:word;
begin
     for i:=160 to 4000-160 do mem[$b800:i]:=mem[$b800:i+160];
     gotoxy (1,24);
end;

procedure screentobuffer;
var i:integer;
begin
     for i:=160 to 4000 do buffer[i]:=mem[$b800:i];
end;

procedure buffertoscreen;
var i:integer;
begin
     for i:=160 to 4000 do mem[$b800:i]:=buffer[i];
end;

PROCEDURE caja( x1, y1, x2, y2 : INTEGER; titulo:STRING;color:byte );
VAR
   Cont : INTEGER;

BEGIN
     TextBackGround(color);
     TextColor (C_smlWin);
     FOR Cont:=x1+1 TO x2-1 DO
         BEGIN
              GOTOXY (Cont,y1);WRITE ('');
              GOTOXY (Cont,y2);WRITE ('');
         END;
     Gotoxy(x1, y1); WRITE ('');GOTOXY (x2,y1);WRITE ('');
     Gotoxy(x1, y2); WRITE ('');GOTOXY (x2,y2);WRITE ('');

     FOR Cont := y1+1 TO y2-1 DO
         BEGIN
              Gotoxy( x1, Cont ); WRITE('');
              Gotoxy( x2, Cont ); WRITE('');
         END;
     TextColor (C_Normal);
     IF titulo <> '' THEN
        BEGIN
              Gotoxy( x1+1, y1+1 ); WRITE (titulo);
              Gotoxy(x1+1,y1+2);
              for cont:=1 to x2-x1-1 do write ('');
        END;
     TextBackGround (C_2ndBG);
END;

procedure dec(var outdec:byte;inhex:cad2;var error:boolean);
var nl,nh:byte;
begin
     error:=false;
     nh:=ord(inhex[1]);nl:=ord(inhex[2]);
     if nl>ord('Z') then nl:=nl-32;
     nl:=nl-48;if nl>16 then nl:=nl-7;
     if nh>ord('Z') then nh:=nh-32;
     nh:=nh-48;if nh>16 then nh:=nh-7;
     if (nh>15) or (nl>15) then error:=true;
     outdec:=nh*16+nl;
end;

procedure decadr(var outdec:word;inhex:cad4;var error:boolean);
var nl,nh:cad2;
    l,h:byte;
    error2:boolean;
begin
     nh:=inhex[1]+inhex[2];dec(h,nh,error);
     nl:=inhex[3]+inhex[4];dec(l,nl,error2);
     outdec:=h*256+l;
     error:=error or error2;
end;

procedure lee(n:byte);   { lee un string de n chars y devuelve string frase}
var  i,a:byte;
     cad: string;
     error:integer;
begin     i:=1;
          cad[i]:=readkey;
          while ((i<n) and (cad[i]<>#13)) do
                begin
                     if (cad[i]<>#13) and (cad[i]<>#8) and (cad[i]<>#0) then write (cad[i]);
                     if (cad[i]=#8) and (i=1) then i:=0;
                     if (cad[i]=#8) and (i>1) then
                         begin
                              i:=i-2;
                              write(#8,#32,#8);
                         end;
                     if (cad[i]<>#0) then i:=i+1;
                     cad[i]:=readkey;
                end;
          if cad[i]<>#13 then write(cad[i]);
          if cad[i]=#13 then i:=i-1;
          cad[0]:=chr(i);
          frase:=cad;
          for i:=1 to ord(frase[0]) do if (frase[i]>='a') and (frase[i]<='z') then frase[i]:=chr(ord(frase[i])-32);
end;

procedure quitacar;
begin
     line:=Copy (line,2,ord(line[0])-1);
end;

procedure quitaespacios;
begin
     while (line[1]=' ') and (ord(line[0])>0) do quitacar;
end;

procedure request(texto:string;timdel:boolean);

Var
   tmp, x : Byte;
   s      : String[80];

begin
      x:=Length(About) div 2;
      screentobuffer;
      caja (32-x,5,39+x,9,'  '+About+'   ',black);
      gotoxy (33-x,8);
      TextColor (C_Info);
      s:='';
      For tmp:=1 To Length (About)+4 Do s:=s+#32;
      write(s);
      gotoxy (33-x,8);
      write(texto);
      gotoxy (80,1);
      if timdel then key:=readkey
      else delay (WIN_DELAY);
      buffertoscreen;
end;

procedure exit;
begin
     salir:=true;
end;

Procedure dosshell;

Var
   x, y : Byte;
   attr : Word;

Begin
     Move (ColorBuf, FrameBuf4, $FA0);
     x:=WhereX; y:=WhereY; attr:=TextAttr;
     TextAttr:=$7; ClrScr;
     WriteLn ('Type EXIT to return to ', About, #$0a, #$0d);
     exec(getenv('Comspec'),'');
     Move (FrameBuf4, ColorBuf, $FA0);
     TextAttr:=attr; GotoXY (X, Y);
End;

procedure findfile;
var tmp:cad4;
begin
     i:=0;
     found:=FALSE;
     COUNT:=0;      { current byte of selected file }
     quitacar;
     quitaespacios;
     tmp:=copy(line,1,4);
     decadr(filename,tmp,error);
     line:=copy(line,5,ord(line[0])-4);
     quitaespacios;
     if not error then while ((i<41) and (not found)) do
        begin
             i:=i+1;
             if (nam[i]=filename) then found:=TRUE;
        end;
     if found then filenum:=i
     else begin
               writeln (' FILE NOT FOUND IN LINE ',numline);
               LOADERR:=TRUE;
          end;
end;

procedure storebyte(mem:boolean);
var tmp:cad2;
begin
    while ((ord(line[0])>1) and not error and (line[1]<>';')) do
          begin
               tmp:=copy(line,1,2);
               dec(dumy,tmp,error);
               COUNT:=COUNT+1;
               if mem then men[filenum,COUNT]:=dumy
               else fil[filenum,COUNT]:=dumy;
               quitacar;
               quitacar;
               quitaespacios;
               if ((line[1]=#$0a) or (line[1]=#$0d)) then line[0]:=#0;
          end;
    if error then
       begin
             LOADERR:=TRUE;
             writeln;
             writeln ('  Error in line: ',numline);
       end;
end;

procedure storekey;
var tmp:cad2;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     COUNT:=0;
     while ((ord(line[0])>1) and not error and (line[1]<>';')) do
        begin
             tmp:=copy(line,1,2);
             dec(dumy,tmp,error);
             skey[count]:=dumy;
             count:=count+1;
             quitacar;
             quitacar;
             quitaespacios;
             if ((line[1]=#$0a) or (line[1]=#$0d)) then line[0]:=#0;
        end;
    if error then begin
                       LOADERR:=TRUE;
                       writeln;
                       writeln ('  Error in KEY ');
                  end
end;

procedure storeatr;
var tmp:cad2;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     COUNT:=0;
     tmp:=copy(line,1,2);
     dec(dumy,tmp,error);
     quitacar;
     quitacar;
     quitaespacios;
     if (error or (dumy>32)) then
        begin
             writeln('Error in ATR LENGHT');
             LOADERR:=TRUE;
        end
     else begin
               atrlen:=dumy;
               conven:=TRUE;  { assumes direct convention }
               while ((ord(line[0])>1) and not error and (line[1]<>';')) do
                     begin
                          tmp:=copy(line,1,2);
                          dec(dumy,tmp,error);
                          count:=count+1;
                          atr[count]:=dumy;
                          quitacar;
                          quitacar;
                          quitaespacios;
                          if ((line[1]=#$0a) or (line[1]=#$0d)) then line[0]:=#0;
                     end;
               if error then
                  begin
                       LOADERR:=TRUE;
                       writeln;
                       writeln ('  Error in ATR FILE');
                  end
               else if (atr[1]=$3F) then conven:=FALSE;
           end;
end;

procedure storecom;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     comnum:=line[1];
     case comnum of
                       '1': serie:=COM1;
                       '2': serie:=COM2;
                       '3': serie:=COM3;
                       '4': serie:=COM4;
                        else writeln;
                             writeln (' ERROR SERIAL PORT NOT VALID ');
                             LOADERR:=TRUE;
                        end;
end;

procedure storebaud;
var tmp:word;
begin
     quitacar;
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     line:=copy (line,1,pos(' ',line)-1);
     val (line,tmp,i);
     if ((i<>0) or (tmp=0)) then
        begin
             writeln;
             writeln (' ERROR BAUD RATE NOT VALID ');
             LOADERR:=TRUE;
        end
     else velocidad:=tmp;
end;

procedure storepin;
var tmp:word;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     line:=copy (line,1,pos(' ',line)-1);
     val (line,tmp,i);
     if ((i<>0) or (tmp=0)) then
        begin
             writeln;
             writeln (' ERROR PIN NOT VALID ');
             LOADERR:=TRUE;
        end
     else pin:=tmp;
end;

procedure storedly;
var tmp:word;
begin
     quitacar;
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     line:=copy (line,1,pos(' ',line)-1);
     val (line,tmp,i);
     if ((i<>0) or (tmp=0)) then
        begin
             writeln;
             writeln (' ERROR INTER BYTE DELAY NOT VALID ');
             LOADERR:=TRUE;
        end
     else bytedly:=tmp;
end;

Procedure CharXY (X, Y : Byte; ch : Char);

Var Offset   : Word;
    AdressP  : Word Absolute $0040:$004E;

Begin
    Offset := (Y-1) * 160 + X Shl 1;
    Mem[$B800:Offset+1] := TextAttr;
    Mem[$B800:Offset]   := Ord (CH);
    
End;


Procedure dump (adr:word);

Var
    k, n, X, Y : Byte;

Begin
     TextBackGround (C_DumpBG); TextColor (C_DumpS1);
     Write (HexAdr(adr));
     Write ('       ');
(*     GotoXY (WhereX+7, WhereY);*)
     TextColor (C_DumpS2);
     for k:=0 to 15 Do
         Begin
              If k<>15 Then
                 Write(Hex(CLO[adr+k]), ' ') Else
                 Write(Hex(CLO[adr+k]));
(*              GotoXY (WhereX+1, WhereY);*)
         End;
     Write ('  ');
     X:=WhereX-1; Y:=WhereY;
     TextColor (C_DumpS3);
     for k:=0 to 15 do
         begin
              n:=CLO[adr+k];
{              if n<31 then n:=128+n;
              write(chr(n));}
              CharXY (X, Y, chr(n));
              Inc (X);
         end;
     if wherey<25 then writeln;
End;

Procedure Edited_Dump (adr:word);

Var
    k, n, X, Y : Byte;

Begin
     TextBackGround (C_DumpBG); TextColor (C_DumpS1);
     Write (HexAdr(adr));
     Write ('       ');
(*     GotoXY (WhereX+7, WhereY);*)
     TextColor (C_DumpS2);
     for k:=0 to 15 Do
         Begin
              If k<>15 Then
                 Write(Hex(CLO[adr+k]), ' ') Else
                 Write(Hex(CLO[adr+k]));
(*              GotoXY (WhereX+1, WhereY);*)
         End;
     Write ('  ');
     X:=WhereX-1; Y:=WhereY;
     TextColor (C_DumpS3);
     for k:=0 to 15 do
         begin
              n:=CLO[adr+k];
{              if n<31 then n:=128+n;
              write(chr(n));}
              CharXY (X, Y, chr(n));
              Inc (X);
         end;
     if wherey<25 then writeln;
End;


procedure pagedown;
var i:word;
begin
     gotoxy(1,2);
     inicio:=inicio+16*24;
     if inicio>3712 then inicio:=3712;
     for i:=0 to 23 do dump(inicio+i*16);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure pageup;
var i:word;
begin
     gotoxy(1,2);
     if inicio<16*24 then inicio:=16*24;
     inicio:=inicio-16*24;
     for i:=0 to 23 do dump(inicio+i*16);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure scrollup;
var i:word;
begin
     i:=2000;
     while i>80 do
           begin
                screen[2*i]:=screen[2*i-160];
                i:=i-1;
           end;
     inicio:=inicio-16;
     gotoxy (1,2);
     dump (inicio);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure scrolldown;
var i:word;
begin
     for i:=80 to 2000 do screen[2*i]:=screen[2*i+160];
     inicio:=inicio+16;
     gotoxy(1,25);
     dump (inicio+23*16);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

Procedure seeframe;

Var
   PrecAttr : Byte;
   xxx, yyy : Byte;


begin
     inicio:=0;
     gotoxy (1,2);
     xpos:=1;
     ypos:=1;
     for i:=0 to 23 do dump ((inicio+i*16));
     key:=#0;
     PrecAttr:=Screen[2*(ypos*80+xpos)-1];
     Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
     while key<>#27 do
           begin
                key:=readkey;
                if key=#0 then key:=readkey;
                if key=#71 { HOME } Then
                   Begin
                        Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                        xpos:=X_START_HEX;
                        PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                        Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                   End;
                if key=#79 { END } Then
                   Begin
                        Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                        xpos:=X_LIMIT_HEX-2;
                        PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                        Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                   End;

                if key=#9 { TAB } Then
                   Begin
                        yyy:=ypos;
                        For xxx:=xpos to X_LIMIT_HEX Do
                            If Not(Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) Then break;
                        If Not(Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) Then
                           For xxx:=xxx to X_LIMIT_HEX Do
                            If (Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) Then break;
                        If (Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) and (xxx<X_LIMIT_HEX) Then
                           Begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xxx+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           End;
                   End;
                if key=#80 then
                   begin
                        if ypos<24 then
                           begin
                                Screen[2*(ypos*80+xpos)-1]:=PrecAttr;
                                ypos:=ypos+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           end
                        else if inicio <($1000-24*16) then scrolldown;
                   end;
                if key=#72 then
                   begin
                        if ypos>1 then
                           begin
                                Screen[2*(ypos*80+xpos)-1]:=PrecAttr;
                                ypos:=ypos-1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           end
                        else if inicio >0 then scrollup;
                   end;
                if key=#77 then
                   begin
                        if xpos<80 then
                           begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xpos+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;

                           end
                   end;
                if key=#75 then
                   begin
                        if xpos>1 then
                           begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xpos-1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           end
                   end;
                if key=#81 then pagedown;
                if key=#73 then pageup;

           end;
     Screen[2*(ypos*80+xpos)-1]:=PrecAttr;
end;

Function GetCurrentAddress (xpos, ypos : Byte) : Word;

Var
   HexDigit : Byte;
   BaseAddr : Word;
   CntValue : Byte;

Begin
     BaseAddr:=0; { RelAddr:=0; }

     BaseAddr:=(xpos-X_START_HEX) div 3; { Relative byte-address }

{     CntValue:=}

     { Now, get the exact hex offset }

     HexDigit:=(Screen[2*(ypos*80)+4]);
      If (HexDigit<=57) Then HexDigit:=HexDigit-48 Else HexDigit:=HexDigit-55;
     BaseAddr:=BaseAddr+HexDigit*$10;
     HexDigit:=(Screen[2*(ypos*80)+2]);
      If (HexDigit<=57) Then HexDigit:=HexDigit-48 Else HexDigit:=HexDigit-55;
     BaseAddr:=BaseAddr+HexDigit*$100;
     HexDigit:=(Screen[2*(ypos*80)]);
      If (HexDigit<=57) Then HexDigit:=HexDigit-48 Else HexDigit:=HexDigit-55;
     BaseAddr:=BaseAddr+HexDigit*$1000;
End;

Procedure EditHex;

Function EditAllowed : Boolean;

Begin
     If (xpos>=X_START_HEX) And (xpos<=X_LIMIT_HEX) And (((xpos-14) mod 3)<>0) Then
        EditAllowed:=True
        Else EditAllowed:=False;
End;

Var
   PrecAttr, SaveAttr : Byte;
   SpecialKey         : Boolean;
   xxx, yyy           : Byte;
   curr_addr          : Word;

begin
     gotoxy (50,1);
     write ('       Hex Edit Mode       ');
     TextBackGround (C_2ndBG);
     gotoxy (1,2);

     inicio:=0;
     gotoxy (1,2);
     xpos:=1;
     ypos:=1;
     for i:=0 to 23 do dump ((inicio+i*16));
     key:=#0;
     PrecAttr:=Screen[2*(ypos*80+xpos)-1];
     Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
     while key<>#27 do
           begin
                key:=UpCase(readkey); SpecialKey:=False;
                if key=#0 then
                   Begin
                        key:=readkey;
                        SpecialKey:=True;
                   End;
              If SpecialKey Then Begin
                if key=#71 { HOME } Then
                   Begin
                        Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                        xpos:=X_START_HEX;
                        PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                        Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                   End;
                if key=#79 { END } Then
                   Begin
                        Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                        xpos:=X_LIMIT_HEX-2;
                        PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                        Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                   End;

                if key=#9 { TAB } Then
                   Begin
                        yyy:=ypos;
                        For xxx:=xpos to X_LIMIT_HEX Do
                            If Not(Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) Then break;
                        If Not(Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) Then
                           For xxx:=xxx to X_LIMIT_HEX Do
                            If (Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) Then break;
                        If (Char (Screen[2*(yyy*80+xxx)]) in ['0'..'Z']) and (xxx<X_LIMIT_HEX) Then
                           Begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xxx+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           End;
                   End;
                if key=#80 then
                   begin
                        if ypos<24 then
                           begin
                                Screen[2*(ypos*80+xpos)-1]:=PrecAttr;
                                ypos:=ypos+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           end
                        else if inicio <($1000-24*16) then scrolldown;
                   end;
                if key=#72 then
                   begin
                        if ypos>1 then
                           begin
                                Screen[2*(ypos*80+xpos)-1]:=PrecAttr;
                                ypos:=ypos-1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           end
                        else if inicio >0 then scrollup;
                   end;
                if key=#77 then
                   begin
                        if xpos<80 then
                           begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xpos+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;

                           end
                   end;
                if key=#75 then
                   begin
                        if xpos>1 then
                           begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xpos-1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                           end
                   end;
                if key=#81 then pagedown;
                if key=#73 then pageup;
             End Else (* Not a special key *) Begin
                If (key in ['A'..'F','0'..'9']) and (EditAllowed) Then
                   Begin
                        SaveAttr:=TextAttr;
                        TextColor (C_Eviden);
                        Screen[(ypos*80+xpos)*2-1]:=TextAttr;
                        Screen[(ypos*80+xpos)*2-2]:=Ord (key);
                        TextAttr:=SaveAttr;

                        { Now patch the clone card undo-buffer }

                        curr_addr:=GetCurrentAddress (xpos, ypos);

                        { Move the virtual cursor to the right }

                        xpos:=xpos+1;
                        PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                        Screen[2*(ypos*80+xpos)-1]:=A_Cursor;
                   End;
             If (Key=#32) Then
                if xpos<80 then
                           begin
                                Screen[(ypos*80+xpos)*2-1]:=PrecAttr;
                                xpos:=xpos+1;
                                PrecAttr:=Screen[2*(ypos*80+xpos)-1];
                                Screen[2*(ypos*80+xpos)-1]:=A_Cursor;

                           end
            End; (* Not a special Key *)
           end;
     Screen[2*(ypos*80+xpos)-1]:=PrecAttr;
End;

(*
procedure edithex;
VAR especial:boolean;
    nh,nl,old:byte;

function valid:boolean;
begin
     valid:=true;
     if ((xpos-14) mod 3)=0 then valid:=false;
end;

begin
     gotoxy (50,1);
     write ('        HEX EDIT           ');
     TextBackGround (C_2ndBG);
     gotoxy (1,2);
     xpos:=1;
     ypos:=1;
     for i:=0 to 23 do dump ((inicio+i*16));
     xpos:=12;
     { primer caracter hex }
     key:=#0;
     while key <>#27 do
           begin
                screen[2*(ypos*80+xpos)-1]:=71;
                especial:=false;
                key:=readkey;
                if key=#0 then
                   begin
                        key:=readkey;
                        especial:=true;
                   end;
                if especial then
                   begin
                        if  key=#77  then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  xpos:=xpos+1;
                                  if xpos >58 then
                                     begin
                                          xpos:=12;
                                          ypos:=ypos+1;
                                     end;
                                  if ypos>24 then ypos:=24;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                        if  key=#75  then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  xpos:=xpos-1;
                                  if xpos<12 then
                                     begin
                                          xpos:=58;
                                          ypos:=ypos-1;
                                     end;
                                  if ypos<1 then ypos:=1;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                        if ((key=#80) and (ypos<24)) then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  ypos:=ypos+1;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                        if ((key=#72) and (ypos>1)) then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  ypos:=ypos-1;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                   end
                else if (key >#31) and (valid) then
                     begin
                           if (xpos mod 3)=0 then
                              begin
                                   old:=clo[inicio+(xpos-12) div 3+16*(ypos-1)];
                                   old:=(old and $0f);
                                   nh:=ord(key);
                                   if nh>ord('Z') then nh:=nh-32;
                                   nh:=nh-48;if nh>16 then nh:=nh-7;
                                   if nh<16 then
                                      begin
                                           gotoxy (xpos,ypos+1);
                                           write (key);
                                           old:=nh*16+old;
                                           clo[inicio+(xpos-12) div 3+16*(ypos-1)]:=old;
                                           gotoxy ((xpos-12) div 3+61,ypos+1);
                                           write (chr(old));
                                           xpos:=xpos+1;
                                           gotoxy (xpos,ypos+1);
                                      end;
                              end
                           else begin
                                     old:=clo[inicio+(xpos-12) div 3+16*(ypos-1)];
                                     old:=(old and $f0);
                                     nl:=ord(key);
                                     if nl>ord('Z') then nl:=nl-32;
                                     nl:=nl-48;if nl>16 then nl:=nl-7;
                                     if nl<16 then
                                        begin
                                             gotoxy(xpos,ypos+1);
                                             write (key);
                                             old:=old+nl;
                                             clo[inicio+(xpos-12) div 3+16*(ypos-1)]:=old;
                                             gotoxy ((xpos-13) div 3+61,ypos+1);
                                             write (chr(old));
                                             xpos:=xpos+2;
                                             gotoxy (xpos,ypos+1);
                                        end;
                                end;
                           if xpos >58 then
                              begin
                                   xpos:=12;
                                   ypos:=ypos+1;
                              end;
                           if ypos>24 then ypos:=24;
                     end;
           end;
    screen[2*(ypos*80+xpos)-1]:=127;
end;
*)

procedure clearbuf;
begin
     for i:=0 to 4095 do clo[i]:=0;
end;


procedure analice;
begin
     for i:=1 to ord(line[0]) do if (line[i]>='a') and (line[i]<='z') then line[i]:=chr(ord(line[i])-32);
     if (line[1]='*') then
        begin
             if line[2]='*' then
                begin
                     quitacar;
                     quitacar;
                     quitaespacios;
                end
             else findfile;
             storebyte(TRUE);
        end
     else if (line[1]='#') then
          begin
               if line[2]='#' then
                  begin
                       quitacar;
                       quitacar;
                       quitaespacios;
                  end
               else findfile;
               storebyte(FALSE);
          end
    else if (line[1]='!') then
         begin
              quitacar;
              quitaespacios;
              if copy(line,1,3)='ATR' then storeatr
              else if copy(line,1,3)='COM' then storecom
                   else if copy(line,1,4)='BAUD' then storebaud
                        else if copy(line,1,3)='PIN' then storepin
                             else if copy(line,1,3)='KEY' then storekey
                                  else if copy(line,1,4)='BDLY' then storedly;
         end
    else begin
              writeln ('  Error at line: ',numline);
              LOADERR:=TRUE;
         end;
end;

procedure loads19;
var k:byte;
    a:char;
    p,n:cad2;
    adr:cad4;
    cont,suma:byte;
    error,chk:boolean;
begin
     assign (inp,infile);
     reset (inp);
     error:=false;
     read(inp,p);while (p<>'S1') and (p<>'S9') do read(inp,p);
     while not eof(inp) and (p<>'S9') and (not error) and not keypressed do
           begin
                read(inp,n);
                dec(cont,n,error);
                suma:=cont;
                cont:=cont-3;
                read(inp,adr);
                decadr(inicio,adr,error);
                suma:=suma+lo(inicio)+hi(inicio);
                for k:=0 to cont-1 do
                    begin
                         read(inp,n);
                         dec(dumy,n,error);
                         suma:=suma+dumy;
                         clo[inicio+k]:=dumy;
                    end;
                suma:= not suma;
                read(inp,p);  {checksum}
                dec(dumy,p,error);
                if (dumy<>suma) and chk then loaderr:=true;
                read(inp,a);
                read(inp,a);
                while (p<>'S1') and (p<>'S9') and not eof(inp) and not keypressed do read(inp,p);
           end;
     close (inp);
     clearpan;
     gotoxy (2,3);
     TextColor (C_Alert);
     if LOADERR then write (' CHECKSUM ERROR LOADING FRAME FILE ')
     else if keypressed then write (' LOAD FRAME ABORTED BY USER ')
          else begin
                    inicio:=0;
                    gotoxy (1,2);
                    TextColor (C_Normal);
                    for i:=0 to 23 do dump ((inicio+i*16));
               end;
end;

procedure SAVES19;
var cont,k:word;
    suma:byte;
    Nbytes,j:byte;

begin
     inicio:=0;
     Nbytes:=16+3;
     cont:=($1000-inicio) div (Nbytes-3);
     for k:=1 to cont do
         begin
              write(inp,'S1',hex(Nbytes),hex(hi(inicio)),hex(lo(inicio)));
              suma:=Nbytes+lo(inicio)+hi(inicio);
              for j:=0 to Nbytes-4 do
                  begin
                       suma:=suma+clo[inicio+j];
                       write(inp,hex(clo[inicio+j]));
                  end;
              writeln (inp,hex(not suma));
              inicio:=inicio+16;
         end;
     writeln(inp,'S9',hex(3),hex(0),hex(0),hex($FC));
     {$i+} close(inp);
     inicio:=0;
end;

procedure carga;
begin
      LOADERR:=FALSE;
      assign(t,infile);
      {$I-} reset(t); {$I+}
      if ioresult<>0 then request('ERROR FILE NOT FOUND.',TRUE)
      else begin
             numline:=0;
             assign (inp,infile);
             reset (inp);
             request(' Loading SIM File. ',FALSE);
             clearpan;
             gotoxy (2,2);
             while not eof(inp) do
                   begin
                        readln(inp,line);
                        line:=line+'   ';
                        quitaespacios;
                        if ((ord(line[0])>0) and (line[1]<>';')) then analice;
                        numline:=numline+1;
                   end;
             close(inp);
             writeln;
             TextColor (C_Alert);
             if LOADERR then write ('  SOME ERRORS FOUND LOADING SIM FILE')
             else begin
                       clearpan;
                       gotoxy (2,3);
                       TextColor (C_Alert);
                       write ('SIM FILE LOADED SUCCESFULLY');
                       out;
                       init; { RE INITS UART }
                  end;
      end;
end;

Function GetFileName (FMask : String; Var s : String) : Word;

Var FFilelist : FileListP;
    NomF      : String;

Begin
   With FFileList Do Begin

       X0       := 3;        { Size                    }
       X1       := 75;       {         of              }
       Y0       := 5;        {             the         }
       Y1       := 19;       {                  window }
       TAttr    := 30;{ window color attribut   }
       TBarre   := 57;       { bar color attribut      }
       Masque   := FMask;    { File Mask               }
       Attribut := $3F-$08;  { AnyFile - VolumeId      }
       ChgRep   := True;     { Return to original path }

   End;
   s := GetFName (FFileList);
   GetFileName:=flTouche;
End;

Procedure CargaFra;

Begin
             assign(t,infile);
             {$I-} reset(t); {$I+}
             if ioresult=0 then
             begin
                  request(' Loading Frame File. ',FALSE);
                  i:=0;
                  while not eof(t) and (i<MAXFRAME) do
                        begin
                             read(t,dumy);
                             clo[i]:=dumy;
                             i:=i+1;
                        end;
                        close(t);
                        clearpan;
                        gotoxy (2,3);
                        TextColor (C_Alert);
                        inicio:=0;
                        gotoxy (1,2);
                        TextColor (C_Normal);
                        for i:=0 to 23 do dump ((inicio+i*16));
             end
             else Begin
                       Request ('ERROR LOADING THE FILE.',TRUE);
                  End;
End;

Procedure LoadFraBIN;

Var
   x, y : Byte;
   attr : Word;

Begin
     Move (ColorBuf, FrameBuf4, $FA0);
     x:=WhereX; y:=WhereY; attr:=TextAttr;

     If (GetFileName ('*.BIN', InFile)=13) Then
        Begin
             LOADERR:=FALSE;

             assign(t,infile);
             {$I-} reset(t); {$I+}
             if ioresult=0 then
             begin
                  i:=0;
                  while not eof(t) and (i<MAXFRAME) do
                        begin
                             read(t,dumy);
                             clo[i]:=dumy;
                             i:=i+1;
                        end;
                        close(t);
                        clearpan;
                        gotoxy (2,3);
                        TextColor (C_Alert);
                        inicio:=0;
                        gotoxy (1,2);
                        TextColor (C_Normal);
                        for i:=0 to 23 do dump ((inicio+i*16));
             end
             else Begin
                       Request ('ERROR LOADING THE FILE.',TRUE);
                       Move (FrameBuf4, ColorBuf, $FA0);
                       TextAttr:=attr; GotoXY (X, Y);
                  End;

        End Else Begin
                      Move (FrameBuf4, ColorBuf, $FA0);
                      TextAttr:=attr; GotoXY (X, Y);
                 End;
End;

Procedure LoadSIM;

Var
   x, y  : Byte;
   attr  : Word;
   LoadF : Boolean;

Begin
     Move (ColorBuf, FrameBuf4, $FA0);
     x:=WhereX; y:=WhereY; attr:=TextAttr;

     loadf:=(GetFileName ('*.DAT', InFile)=13);

     Move (FrameBuf4, ColorBuf, $FA0);
     TextAttr:=attr; GotoXY (X, Y);

     If LoadF Then Carga;
End;

Procedure loadfras19;

Var
   x, y  : Byte;
   attr  : Word;
   LoadF : Boolean;


Begin
      LOADERR:=FALSE;
      Move (ColorBuf, FrameBuf4, $FA0);
      x:=WhereX; y:=WhereY; attr:=TextAttr;

      loadf:=(GetFileName ('*.S19', InFile)=13);

      If LoadF Then
         Begin
              Assign(t,infile);
              {$I-} reset(t); {$I+}
              If ioresult<>0 then request('ERROR LOADING FILE.',TRUE)
              Else loads19;
         End Else
         Begin
              Move (FrameBuf4, ColorBuf, $FA0);
              TextAttr:=attr; GotoXY (X, Y);
         End;
end;

Procedure comparebin;

Var
   x, y   : Byte;
   attr   : Word;
   LoadF  : Boolean;
   Verify : Boolean;

Begin
      verify:=TRUE;

      Move (ColorBuf, FrameBuf4, $FA0);
      x:=WhereX; y:=WhereY; attr:=TextAttr;

      loadf:=(GetFileName ('*.BIN', InFile)=13);
      If LoadF Then
         Begin
              Move (FrameBuf4, ColorBuf, $FA0);
              Move (ColorBuf, FrameBuf4, $FA0);

              TextAttr:=attr; GotoXY (X, Y);

        LOADERR:=FALSE;
        assign(t,infile);
        {$I-} reset(t); {$I+}
        if ioresult=0 then
           begin
              clearpan;
              gotoxy (1,3);
              TextColor (C_Alert);
              i:=0;
              while not eof(t) and (i<MAXFRAME) do
                    begin
                         read(t,dumy);
                         if clo[i]<>dumy then
                            begin
                                 verify:=FALSE;
                                 writeln ('Adress $',hexadr(i),' buffer=$',hex(clo[i]),' file=$',hex(dumy));
                                 if (wherey>=25) then doscroll;
                            end;
                         i:=i+1;
                    end;
                    close(t);
                    if verify then writeln ('BUFFER AND FILE CONTENTS ARE EQUAL');
         end
      else request('ERROR FILE NOT FOUND.',TRUE);
      End Else Begin
      Move (FrameBuf4, ColorBuf, $FA0);
           TextAttr:=attr; GotoXY (X, Y); End;
end;


procedure savefras19;
begin
      screentobuffer;
      caja (25,5,58,9,'   SAVE  *.S19   FRAME FILE     ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      TextColor (C_Info);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.S19';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(inp,infile);
      {$i-} rewrite(inp);
      if ioresult=0 then SAVES19
      else request('ERROR WRITING FILE.',TRUE)
end;



procedure savefrabin;

Var
   Thresold : Word;

begin
      If (BigBuffer) Then Thresold:=MAXFRAME
         Else Thresold:=4096;
      screentobuffer;
      caja (25,5,58,9,'   SAVE  *.BIN   FRAME FILE     ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      TextColor (C_Info);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.BIN';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(t,infile);
      {$i-} rewrite(t);
      if ioresult=0 then
         begin
              i:=0;
              while (i<Thresold) do
                    begin
                         dumy:=clo[i];
                         write(t,dumy);
                         i:=i+1;
                     end;
              {$i+} close(t);
              inicio:=0;
         end
      else request('ERROR WRITING FILE.',TRUE)
end;

procedure notload;
begin
     clearpan;
     TextColor (C_Alert);
     gotoxy (3,3);
     write (' No SIM file Loaded.  ');
end;

procedure dispfile;
var tmp:byte;
begin
     i:=0;
     found:=false;
     gotoxy (1,3);
     if not error then while ((i<41) and (not found)) do
        begin
             i:=i+1;
             if (nam[i]=filename) then found:=TRUE;
        end;
     if not found then writeln (' ERROR BAD FILE ')
     else begin
               filenum:=i;
               i:=1;
               write ('    ',hexadr(filename),'  ');
               while (i<men[filenum,4]) do
                     begin
                          if ((men[filenum,4]-i)<15) then tmp:=men[filenum,4]-i+1
                          else tmp:=16;
                          for dumy:=1 to tmp do write (hex(fil[filenum,i+dumy-1]),' ');
                          writeln;
                          write ('          ');
                          i:=i+dumy;
                     end;
          end;
end;

procedure seead;
begin
     clearpan;
     gotoxy (2,3);
     filename:=$6fad;
     error:=false;
     dispfile;
     gotoxy (40,3);
     TextColor (C_Alert);
     if (fil[filenum,1]and$80)=$80 then write ('VALID MOTOROLA TEST CARD')
     else write ('NOT VALID MOTOROLA TEST CARD');
end;

procedure seeimsi;
begin
     clearpan;
     gotoxy (2,3);
     filename:=$6F07;
     error:=false;
     dispfile;
     gotoxy (50,3);
     TextColor (C_Alert);
     for i:=2 to fil[filenum,1]+1 do write (ihex(fil[filenum,i]));
end;

procedure seeiccard;
begin
     clearpan;
     gotoxy (2,3);
     filename:=$2FE2;
     error:=false;
     dispfile;
     gotoxy (50,3);
     TextColor (C_Alert);
     for i:=2 to (fil[filenum,1] shr 4)+1 do write (ihex(fil[filenum,i]));
end;

procedure seefile;
begin
     clearpan;
     TextColor (C_Info);
     gotoxy (2,3);
     clearpan;
     screentobuffer;
     gotoxy (2,3);
     caja (25,5,42,9,' See 6FXX FILE. ',black);
     TextColor (C_Info);
     gotoxy (26,8);
     write('                ');
     gotoxy (26,8);
     write('FILE ? : ');
     lee (5);
     buffertoscreen;
     TextColor (C_Normal);
     decadr(filename,frase,error);
     dispfile;
end;

procedure seeatr;
begin
     clearpan;
     TextColor (C_Alert);
     gotoxy (3,3);
     write ('ATR: ');
     TextColor (C_Sim);
     for i:=1 to atrlen do write (hex(atr[i]),' ');
end;

procedure seepin;
begin
     clearpan;
     TextColor (C_Alert);
     gotoxy (3,3);
     write ('PIN: ');
     TextColor (C_Sim);
     write (pin);
end;

 { ---------------------- SIM EMULATION ROUTINES -------------------- }

procedure getiso;
begin
     cla:=0;
     ins:=0;
     CLA:=getbyte;
     if not res then INS:=getbyte;
     if not res then P1:=getbyte;
     if not res then P2:=getbyte;
     if not res then P3:=getbyte;
end;

procedure checkreset;
var atrok:boolean;
begin
     atrok:=false;
     while not atrok and not abort do
           begin
                while (GotReset and not keypressed) do;
                clearpan;
                lastread:= 0;
                last :=0;
                if keypressed then abort:=true
                else begin
                           gotoxy(1,3);
                           TextColor (C_Alert);
                           write ('RESET FROM PHONE ... SENDING ATR.   ');
                           TextColor (C_Info);
                           if sendatr then atrok:=true;
                      end;
           end;
end;

procedure verify_pin;
var tmp:word;
begin
     wait(2000);
     sendbyte (ins);
     write ('PIN VERIFY: ');
     for i:=1 to P3 do frase[i]:=(chr(getbyte));
     frase[0]:=#4;
     val (frase,tmp,i);
     wait(2000);
     if (tmp=pin) then begin
                            write (tmp,' OK');
                            sendbyte ($90);
                            sendbyte ($00);
                        end
     else begin
                write (tmp, ' ERROR');
                sendbyte ($98);
                sendbyte ($04);
          end;
     writeln;
end;

procedure change_pin;
begin
     wait(2000);
     sendbyte (ins);
     write ('CHANGE PIN: ');
     for i:=1 to P3 do write (chr(getbyte));
     writeln;
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure pinoff;
begin
     wait(2000);
     sendbyte (ins);
     write ('PIN OFF: ');
     for i:=1 to P3 do write (chr(getbyte));
     writeln;
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure pinon;
begin
     wait(2000);
     sendbyte (ins);
     write ('PIN ON: ');
     for i:=1 to P3 do write (chr(getbyte));
     writeln;
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure A3A8;
var x: array [0..31] of byte;
    bit: array [0..127] of byte;
    i,j,k,l,m,n,y,z,next_bit:word;
begin
	for i:=16 to 31 do x[i]:=rand[i-16];
	for i:=1 to 8 do begin
		for j:=0 to 15 do x[j]:=skey[j];
		for j:=0 to 4 do
			for k:=0 to ((1 shl j)-1) do
				for l:=0 to ((1 shl (4-j))-1) do begin
					m:= l + k*(1 shl (5-j));
					n:= m + (1 shl (4-j));
					y:= (x[m]+2*x[n]) mod (1 shl (9-j));
					z:= (2*x[m]+x[n]) mod (1 shl (9-j));
					x[m]:= table[j]^[y];
					x[n]:= table[j]^[z];
				end;
		for j:=0 to 31 do for k:=0 to 3 do bit[4*j+k]:= (x[j] shr (3-k)) and 1;
		if (i < 8) then
			for j:=0 to 15 do begin
				x[j+16]:=0;
				for k:=0 to 7 do begin
					next_bit:= ((8*j + k)*17) mod 128;
					x[j+16]:= x[j+16] or (bit[next_bit] shl (7-k));
				end;
			end;
	end;
	for i:=0 to 3 do simoutput[i]:= (x[2*i] shl 4) or x[2*i+1];
	for i:=0 to 5 do simoutput[4+i]:= (x[2*i+18] shl 6) or (x[2*i+18+1] shl 2)
				or (x[2*i+18+2] shr 2);
	simoutput[4+6]:=(x[2*6+18] shl 6) or (x[2*6+18+1] shl 2);
	simoutput[4+7]:=0;
end;

procedure algorithm;
begin
     wait(2000);
     sendbyte (ins);
     write ('AUTHENTICATION REQUEST: ');
     for i:=1 to P3 do begin
                            rand[i-1]:=getbyte;
                            write (HEX(rand[i-1]));
                       end;
     writeln ('SIM OUTPUT: ');
     a3a8;
     filenum:=42;
     for i:=0 to 11 do begin
                            men[42,i+1]:=simoutput[i];
                            write (HEX(simoutput[i]));
                       end;
     writeln;
     sendbyte ($9F);
     sendbyte ($0C);
end;

procedure select;
begin
      i:=0;
      wait (2000);
      found:=false;
      sendbyte (ins); {manda procedure byte}
      filename:=getbyte*256;
      filename:=filename+getbyte;
      write ('SELECT FILE: $',hexadr(filename));
      while ((i<41) and (not found)) do
              begin
                   i:=i+1;
                   if (nam[i]=filename) then found:=TRUE;
              end;
      if found then
              begin
                    filenum:=i;
                    wait (2000);
                    sendbyte ($9F);
                    if ((filename=$7f20) OR (filename=$7f10) OR (filename=$7f21)) then sendbyte ($16)
                    else sendbyte ($0F);
              end
       else   begin
                    wait (2000);
                    write (' NOT FOUND');
                    sendbyte ($94);
                    sendbyte ($04);
              end;
       writeln;
end;

procedure readbin;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('READFILE:    $',hexadr(nam[filenum]));
     for i:=1 to P3 do sendbyte (fil[filenum,i]);
     BigBuffer:=(P3>4096);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure cloneread;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('SENDING FRAME AT ADRESS  $',hexadr(p1*256+p2));
     for i:=1 to P3 do sendbyte(clo[p1*256+p2+i-1]);
     BigBuffer:=(P3>4096);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure clonestore;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('GETING FRAME FROM ADRESS $',hexadr(p1*256+p2));
     for i:=1 to P3 do clo[p1*256+p2+i-1]:=getbyte;
     BigBuffer:=(P3>4096);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure clonepin;
var tmp:word;
begin
     wait(2000);
     sendbyte (ins);
     write ('CLONE PIN: ');
     for i:=1 to P3 do write (chr(getbyte));
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
     writeln;
end;

procedure readrec;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('READREC:     $',hexadr(nam[filenum]),' ',P1);
     for i:=1 to P3 do sendbyte (fil[filenum,(P1-1)*P3+I]);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure message;
begin
     wait (2000);
     sendbyte (ins);
     for i:=1 to P3 do sendbyte (men[filenum,i]);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure writebin;
begin
     wait (2000);
     sendbyte (ins);
     for i:=1 to P3 do fil[filenum,i]:=getbyte;
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure reinit;
begin
     wait (2000);
     sendbyte (ins);
     write ('RESET CHARGE COUNTER: ');
     for i:=1 to P3 do write (HEX(getbyte),' ');
     writeln;
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure sleep;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('SLEEP SIM');
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure emulate;
begin
     abort:=false;
     clearpan;
     gotoxy (5,3);
     TextColor (C_Alert);
     write ('Ki=');
     for i:=0 to 15 do write (hex(skey[i]));
     write('   COM',comnum);
     write('   ',velocidad,' BAUDS');
     write('   DELAY ',bytedly);

     TextColor (C_InfoS);
     gotoxy (8,5);
     write('### WAITING RESET ###');
     TextColor (C_Info);
     gotoxy (79,1);
     lastread:= 0;
     last :=0;
     while not abort do
           begin
                if (GotReset) then checkreset;
                getiso;
                case INS of
                            $20: verify_pin;
                            $24: change_pin;
                            $26: pinoff;
                            $28: pinon;
                            $88: algorithm;
                            $a4: select;
                            $b0: readbin;
                            $b2: readrec;
                            $c0: message;
                            $d6: writebin;
                            $dc: reinit;
                            $fa: sleep;
                 end;
                 if keypressed then abort:=true
                 else if (wherey>=25) then doscroll;
           end;
end;

procedure clonemul;
begin
     abort:=false;
     clearpan;
     gotoxy (5,3);
     TextColor (C_Alert);
     write(' Port= COM',comnum);
     write('   Baud= ',velocidad);
     write('   Delay= ',bytedly);
     write('   ISO Convention ');
     if conven then write ('Direct')
     else write ('Invers');
     TextColor (C_InfoS);
     gotoxy (8,5);
     write('### CLONE CARD EMULATING ... WAITING RESET ###');
     TextColor (C_Info);
     gotoxy (79,1);
     lastread:= 0;
     last :=0;
     while not abort do
           begin
                if (GotReset) then checkreset;
                getiso;
                case INS of
                           $20: clonepin;
                           $b0: cloneread;
                           $d0: clonestore;
                end;
                if keypressed then abort:=true
                else if (wherey>=25) then doscroll;
           end;
end;

{ --------------------------- START of MENU -------------------------}

procedure menu;
const n=4; {max 6 items for menu}
      k=6;
      field:  array[0..k,1..n] of string[20]=
      (('File','View File','Emulator','Clone'),
       ('Load SIM','Reset ATR','Run AUTO','Run CLONE'),
       ('Load FRAME (S19)','PIN','Send ATR','View FRAME '),
       ('Save FRAME (S19)','FILE 6Fxx','Get Iso','Edit FRAME'),
       ('Clear FRAME','ICCARD','Send Proc. Byte','Load FRAME (BIN)'),
       ('DOS SHELL','IMSI','Send SW1 SW2','Save FRAME (BIN)'),
       ('Exit','ADMI. DATA','Send Data','Compare FRAME (BIN)'));

     actfield:array[1..n] of boolean=(false,false,false,false);
var  x,y,oldx,oldy,i,max:byte;
     opc,oldfield:byte;
     tecla:byte;
     ok,ok2:boolean;

function tvalida:boolean;
begin
     tvalida:=false;
     if ((tecla=75) or (tecla=77) or (tecla=27) or (tecla=80) or (tecla=72) or (tecla=13)) then tvalida:=true;
end;

procedure writeItem(num:byte);
var i,j:byte;
begin
     TextBackGround (C_cntsBG);
     max:=length(field[1,num]);
     for i:=2 to k do if length(field[i,num])>max then max:=length(field[i,num]);
     max:=max+6;
     gotoxy (4+12*(num-1),2);
     write('');for i:=1 to max-1 do write('');write('');
     for i:=3 to k+3 do begin
                              gotoxy(4+12*(num-1),i);
                              write('');
                              TextBackGround (C_winBG);
                              for j:=1 to max-1 do write(' ');
                              TextBackGround (C_cntsBG);
                              gotoxy(4+12*(num-1)+max,i);
                              write('');
                         end;
     gotoxy (4+12*(num-1),3+k);
     write('');for i:=1 to max-1 do write('');write('');
     TextBackGround (C_winBG);
     for i:=1 to k do begin
                            gotoxy(6+12*(num-1),2+i);
                            write(field[i,num]);
                      end;
end;

procedure fila(columna:byte);
var i:byte;
begin
     gotoxy(5+12*(x-1),oldy+1);
     TextBackGround (C_winBG);write(' '+field[oldy-1,x]);
     for i:=3 to max-length(field[oldy-1,x]) do write(' ');
     gotoxy(5+12*(x-1),columna+1);
     TextBackGround (C_frillBG);write(' '+field[columna-1,x]);
     for i:=3 to max-length(field[columna-1,x]) do write(' ');
     gotoxy(70,24);
end;

procedure barra(campo:byte);
var i:byte;
    t:String;
begin
     if oldfield<>campo then
         begin
              actfield[oldfield]:=false;
              oldfield:=campo;
              actfield[campo]:=true;
         end;
     TextBackGround (C_winBG);
     TextColor (C_Normal);
     gotoxy(1,1);clreol;
     gotoxy(1,1);for i:=1 to n do
        begin
             if actfield[i] then TextBackGround (C_frillBG);
             gotoxy(4+12*(i-1),1);write(field[0,i]);
             TextBackGround (C_winBG);
        end;
    TextColor (C_About);

    t:=About; t[0]:=Chr(25);
    gotoxy(52,1); write (t);
    TextColor (C_Normal);gotoxy(10,10);
end;

begin
     ok:=false;
     ok2:=false;
     oldy:=2;
     x:=1;
     y:=1;
     oldfield:=2;
     barra (x);
     screentobuffer;
     while not ok do
           begin
                gotoxy (80,1);
                tecla:=0;
                while not tvalida do
                      begin
                           tecla:=ord(readkey);
                           if tecla=0 then tecla:=ord(readkey);
                      end;
                if tecla=27 then
                      begin
                            ok:=true;
                            y:=99;
                      end;
                if tecla=77 then
                      begin
                            x:=x+1;
                            if x>4 then x:=1;
                            barra (x);
                            if y>1 then
                               begin
                                    buffertoscreen;
                                    writeitem(x);
                                    fila(y);
                               end;
                      end;
                 if tecla=75 then
                      begin
                            x:=x-1;
                            if x<1 then x:=4;
                            barra (x);
                            if y>1 then
                               begin
                                    buffertoscreen;
                                    writeitem(x);
                                    fila(y);
                               end;
                      end;
                 if tecla=13 then
                      begin
                            if y>1 then ok:=true
                            else begin
                                       Y:=Y+1;
                                       writeitem (x);
                                       fila (y);
                                       oldy:=y+1;
                                       ok2:=true;
                                   end;
                      end;
                 if ((tecla=80) and (ok2)) then
                      begin
                            if y=1 then y:=2;
                            oldy:=y;
                            y:=y+1;
                            if y>7 then y:=2;
                            fila (y);
                      end;
                 if ((tecla=72) and (ok2)) then
                      begin
                            if y=1 then y:=2;
                            oldy:=y;
                            y:=y-1;
                            if y<2 then y:=7;
                            fila (y);
                      end;
           end;
     barra(5);
     buffertoscreen;
     if y<>99 then begin
                        y:=y-1;
                        opc:=x*10+y;
                        case opc of
                                     11: loadsim;
                                     12: loadfras19;
                                     13: savefras19;
                                     14: begin
                                              clearbuf;
                                              inicio:=0;
                                              gotoxy (1,2);
                                              for i:=0 to 23 do dump ((inicio+i*16));
                                         end;
                                     15: dosshell;
                                     16: exit;

                                     21: if atrlen=0 then notload
                                         else seeatr;
                                     22: if atrlen=0 then notload
                                         else seepin;
                                     23: if atrlen=0 then notload
                                         else seefile;
                                     24: if atrlen=0 then notload
                                         else seeiccard;
                                     25: if atrlen=0 then notload
                                         else seeimsi;
                                     26: if atrlen=0 then notload
                                         else seead;

                                     31: if atrlen=0 then notload
                                         else emulate;
                                     32: ;
                                     33: ;
                                     34: ;
                                     35: ;
                                     36: ;

                                     41: if atrlen=0 then notload
                                         else clonemul;
                                     42: seeframe;
                                     43: edithex;
                                     44: loadfrabin;
                                     45: savefrabin;
                                     46: comparebin;
                        end;
                   end;
end;

Procedure Esit (b : Boolean; state : Byte; Var s : PChar);

Begin
     Case state Of
     0: If b Then Write ('                Value found: ') Else
                  Write ('No value specified, default: ');
     1:  Write (', bad syntax, using default: ');
     2:  If ((b=False) or (StrLen(s)=0)) Then Write ('none') Else Write (StrPas(s));
     End;
End;


Procedure ParseINI (s : String);

Const
     ADAPTER_DEFAULT = 'ASIM-LEGACY';
     ADAPTER_SEASON = 'SEASON';
     PORT_DEFAULT = '1';
     BAUD_DEFAULT = '8736';
     BYTEDELAY_DEFAULT = '4000';
     PIN_DEFAULT = '1234';


{     serie:=COM1;
     velocidad:=8736;
     bytedly:=4000;
     conven:=TRUE;
     pin:=3333;}


Var
   FName,
   Section,
   Entry,
   Target,
   DefaultE : pChar;
   ByteCnt : Integer;
   Value : String;
   ExitCode : Integer;
   Valx : Word;

Begin
     GetMem (FName, Length(s)+1);
     GetMem (Section, 128);
     GetMem (Entry, 128);
     GetMem (Target, 128);
     GetMem (DefaultE, 128);

     StrPCopy(FName, s);
     Write ('loading.. ');
     ReadINIFile (FName);
     WriteLn ('done.');

     Window (1, WhereY, 80, 23);

     { Interface Type }
     TextColor (C_Eviden);
     WriteLn (#$0a, #$0d, 'Interface type', #$0a, #$0d);
     TextColor (C_Slick);
     StrPCopy(Section, 'Interface');
     StrPCopy(Entry, 'Type');
     StrPCopy(DefaultE, ADAPTER_DEFAULT);

     Write ('Adapter:    ');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 0, Target);
     Value:=StrPas (StrUpper(Target));
     Write (Value);
     If ((Value<>ADAPTER_DEFAULT) And (Value<>ADAPTER_SEASON)) Then
        Begin
             Esit (FALSE, 1, Target);
             Write (ADAPTER_DEFAULT);
             Value:=ADAPTER_DEFAULT;
        End;
     If (Value=ADAPTER_DEFAULT) Then adapter:=0 Else adapter:=1;
     WriteLn ('.', #$0a, #$0d);

     { Serial Config }

     TextColor (C_Eviden);
     WriteLn ('Serial configuration', #$0a, #$0d);
     TextColor (C_Slick);

     StrPCopy(Section, 'Serial');
     StrPCopy(Entry, 'Port');
     StrPCopy(DefaultE, PORT_DEFAULT);

     Write ('Serial port:');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 0, Target);
     Value:=StrPas (StrUpper(Target));
     Write (Value);
     If ((Value<>PORT_DEFAULT) And (Value<>'2') And (Value<>'3') And (Value<>'4')) Then
        Begin
             Esit (FALSE, 1, Target);
             Write (PORT_DEFAULT);
             Value:=PORT_DEFAULT;
        End;
     Case Ord(Value[1]) Of
     49: serie:=COM1;
     50: serie:=COM2;
     51: serie:=COM3;
     52: serie:=COM4;
     End;
     WriteLn ('.');

     StrPCopy(Entry, 'Baud');
     StrPCopy(DefaultE, BAUD_DEFAULT);

     Write ('Baudrate:   ');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 0, Target);
     Value:=StrPas (StrUpper(Target));
     Write (Value);

     Val (Value, Valx, ExitCode);

     If ((Value<>BAUD_DEFAULT) And (ExitCode<>0)) Then
        Begin
             Esit (FALSE, 1, Target);
             Write (PORT_DEFAULT);
             Value:=PORT_DEFAULT;
             Val (Value, Valx, ExitCode);
        End;
     velocidad:=Valx;
     WriteLn ('.');


     StrPCopy(Entry, 'ByteDelay');
     StrPCopy(DefaultE, BYTEDELAY_DEFAULT);

     Write ('Bytedelay:  ');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 0, Target);
     Value:=StrPas (StrUpper(Target));
     Write (Value);

     Val (Value, Valx, ExitCode);

     If ((Value<>BAUD_DEFAULT) And (ExitCode<>0)) Then
        Begin
             Esit (FALSE, 1, Target);
             Write (BYTEDELAY_DEFAULT);
             Value:=BYTEDELAY_DEFAULT;
             Val (Value, Valx, ExitCode);
        End;
     bytedly:=Valx;
     WriteLn ('.');


     StrPCopy(Entry, 'PIN');
     StrPCopy(DefaultE, PIN_DEFAULT);

     Write ('PIN:        ');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 0, Target);
     Value:=StrPas (StrUpper(Target));
     Write (Value);

     Val (Value, Valx, ExitCode);

     If ((Value<>PIN_DEFAULT) And (ExitCode<>0) And ((Length (Value)<4) Or (Length (Value)>8))) Then
        Begin
             Esit (FALSE, 1, Target);
             Write (PIN_DEFAULT);
             Value:=PIN_DEFAULT;
             Val (Value, Valx, ExitCode);
        End;
     pin:=Valx;
     WriteLn ('.');

     { Load default }

     DefFrameName:='';
     DefSIMName:='';

     TextColor (C_Eviden);
     Write (#$0a, #$0d, 'Default SIM/frames:         ');
     TextColor (C_Slick);
     StrPCopy(Section, 'LoadDefault');
     StrPCopy(Entry, 'SIM');
     StrPCopy(DefaultE, '');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 2, Target);
     Value:=StrPas (StrUpper(Target));
     DefSIMName:=Value;

     Write (' / ');

     StrPCopy(Section, 'LoadDefault');
     StrPCopy(Entry, 'Frame');
     StrPCopy(DefaultE, '');

     Esit (ReadProfileString (Section, Entry, DefaultE, Target, ByteCnt), 2, Target);
     Value:=StrPas (StrUpper(Target));
     DefFrameName:=Value;

     WriteLn ('.');

     FreeMem (FName, Length(s)+1);
     FreeMem (Section, 128);
     FreeMem (Entry, 128);
     FreeMem (Target, 128);
     FreeMem (DefaultE, 128);

     Window (1, 1, 80, 25);
End;

Var
   x, y : Byte;
   xx   : LongInt;
   xxx  : Char;

begin
     {$M 16384, 0, 65000}

     TextAttr:=$7;
     ClrScr;

     TextAttr:=31; ClrEOL; BigBuffer:=False;
     WriteLn (About, #$0a, #$0d); TextAttr:=$7;

     TextColor (C_Slick);
     Write (Authors, #$0a, #$0d);
     WriteLn (URL, #$0a, #$0d);

     ASIMINI:=ParamStr (0);

     For x:=Length (ASIMINI) DownTo 1 Do
         If ASIMINI[x]=#$2E Then Break;

     ASIMINI[0]:=Char(x);
     ASIMINI:=ASIMINI+CFG_EXT;

     Write ('Now parsing ',ASIMINI,'.. ');

     ParseINI (ASIMINI);

     Move (ColorBuf, FrameBuf2, $FA0);
     GotoXY (1, 23);
     x:=WhereX; y:=WhereY;

     WriteLn (#$0a, #$0d,'Parsing done. Press any key or wait a bit..');

     WaitABit;

{     xx:=TickCount;
     While Not KeyPressed and ((xx+100)>TickCount) Do
           Begin End;
     While KeyPressed Do xxx:=ReadKey;}

     ClrScr;

     checkbreak:=false;
     conven:=TRUE;

     init;
     TextColor (C_Normal);
     TextBackGround (C_MainBG);
     clrscr;
     salir:=false;
     filenum:=21;
     atrlen:=0;
     count:=0;
     for i:=1 to 41 do for j:=1 to 255 do fil[i,j]:=$00;
     for i:=1 to 41 do for j:=1 to 36 do fil[i,j]:=$00;
     clearbuf;
     If DefSIMName<>'' Then
        Begin
             InFile:=DefSIMName;
             Carga;
        End;

     If DefFrameName<>'' Then
        Begin
             InFile:=DefFrameName;
             CargaFra;
        End;


     inicio:=0;
     gotoxy (1,2);
     for i:=0 to 23 do dump ((inicio+i*16));
     While Not Salir
           do Menu;

     Move (FrameBuf2, ColorBuf, $FA0);
     TextAttr:=$7;
     GotoXY (x, y);
     TextColor (C_Eviden);
     WriteLn (#$0a, #$0d,'Have a nice day! ;-)');
     TextColor (C_Slick);
end.
